
//By gaz. www.shadertoy.com
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform sampler2D iChannel0;


// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(gl_FragCoord.xy/iResolution)

    
#define PI	3.14159265359
#define PI2	( PI * 2.0 )

vec2 rotate(in vec2 p, in float t)
{
	return p * cos(-t) + vec2(p.y, -p.x) * sin(-t);
}
    
float map(in vec3 p)
{    
    p.xz = mod(p.xz, 2.5) - 1.25;
    p.x += sin(p.y + PI2 * fract(iGlobalTime * 0.8)) * 0.3;
    vec2 q = vec2(length(p.xz), p.y);
    float de = 1.0;
    return  smoothstep(0.0, 1.2, q.x) - 0.1 * q.y;
} 

vec3 calcNormal(in vec3 p)
{
	const vec2 e = vec2(0.0001, 0.0);
	return normalize(vec3(
		map(p + e.xyy) - map(p - e.xyy),
		map(p + e.yxy) - map(p - e.yxy),
		map(p + e.yyx) - map(p - e.yyx)));
}

float march(in vec3 ro, in vec3 rd)
{
	const float maxd = 50.0;
	const float precis = 0.001;
    float h = precis * 2.0;
    float t = 0.0;
	float res = -1.0;
    for(int i = 0; i < 64; i++)
    {
        if(h < precis || t > maxd) break;
	    h = map(ro + rd * t);
        t += h;
    }
    if(t < maxd) res = t;
    return res;
}

vec3 transform(in vec3 p)
{
    p.yz = rotate(p.yz, sin(iGlobalTime * 0.5) * 0.3 + 2.1);
    p.zx = rotate(p.zx, iGlobalTime * 0.2);
    return p;
}

void main(void)
{
	vec2 p = (2.0 * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
	vec3 col = vec3(0.0);
   	vec3 rd = normalize(vec3(p, -1.8));
	vec3 ro = vec3(0.0, 0.0, 5.0);
    vec3 li = normalize(vec3(0.5, 0.8, 3.0));
    ro = transform(ro);
	rd = transform(rd);
	li = transform(li);
    float t = march(ro, rd);
    if(t > -0.001)
    {
        vec3 pos = ro + t * rd;
        vec3 n = calcNormal(pos);
		float dif = clamp((dot(n, li) + 0.5) * 0.7, 0.3, 1.0);
        float dep = exp(-0.005 * pos.z * pos.z);
        col = texture2D(iChannel0, pos.xz).rgb * dif * dep;
        col = pow(col, vec3(0.8));
	}
   	gl_FragColor = vec4(col, 1.0);
}


